<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/../config/Database.php';
require_once __DIR__ . '/../config/TelegramBot.php';

$db = Database::getInstance()->getConnection();
$bot = new TelegramBot();

$success = '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Update bot token if changed
        $newToken = trim($_POST['bot_token']);
        if ($newToken !== Config::get('TELEGRAM_BOT_TOKEN')) {
            Config::set('TELEGRAM_BOT_TOKEN', $newToken);
            
            // Update webhook with new token
            $webhookUrl = Config::get('TELEGRAM_WEBHOOK_URL');
            $bot->setWebhook($webhookUrl);
        }
        
        // Update other settings
        Config::set('BOT_WELCOME_MESSAGE', trim($_POST['welcome_message']));
        Config::set('BOT_DEFAULT_RESPONSE', trim($_POST['default_response']));
        Config::set('BOT_MAINTENANCE_MODE', $_POST['maintenance_mode'] === '1' ? 'true' : 'false');
        Config::set('TELEGRAM_ADMIN_IDS', trim($_POST['admin_ids']));
        Config::set('TELEGRAM_CHANNEL_ID', trim($_POST['channel_id']));
        
        // Save to .env file
        Config::save();
        
        $success = 'Pengaturan berhasil disimpan!';
    } catch (Exception $e) {
        $error = 'Gagal menyimpan pengaturan: ' . $e->getMessage();
    }
}

// Get current webhook info
$webhookInfo = $bot->getWebhookInfo();

require_once __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Pengaturan Bot</h1>
            </div>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Informasi Webhook</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <tbody>
                                <tr>
                                    <th>URL Webhook</th>
                                    <td><?= htmlspecialchars($webhookInfo['result']['url'] ?? 'Tidak ada') ?></td>
                                </tr>
                                <tr>
                                    <th>Status Webhook</th>
                                    <td>
                                        <?php if ($webhookInfo['result']['url'] ?? false): ?>
                                            <span class="badge bg-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Tidak aktif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Terakhir Error</th>
                                    <td>
                                        <?php if ($webhookInfo['result']['last_error_date'] ?? false): ?>
                                            <?= date('d M Y H:i:s', $webhookInfo['result']['last_error_date']) ?><br>
                                            <small class="text-muted"><?= htmlspecialchars($webhookInfo['result']['last_error_message'] ?? '') ?></small>
                                        <?php else: ?>
                                            Tidak ada error
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Update Terakhir</th>
                                    <td>
                                        <?php if ($webhookInfo['result']['last_synchronization_date'] ?? false): ?>
                                            <?= date('d M Y H:i:s', $webhookInfo['result']['last_synchronization_date']) ?>
                                        <?php else: ?>
                                            Tidak diketahui
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        <form method="post" action="bot-settings.php?action=webhook" class="d-inline">
                            <button type="submit" name="action" value="set" class="btn btn-primary me-2">
                                Set Webhook
                            </button>
                            <button type="submit" name="action" value="delete" class="btn btn-danger">
                                Hapus Webhook
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h5>Konfigurasi Bot</h5>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <label for="bot_token" class="form-label">Bot Token</label>
                            <input type="text" class="form-control" id="bot_token" name="bot_token" 
                                   value="<?= htmlspecialchars(Config::get('TELEGRAM_BOT_TOKEN')) ?>" required>
                            <div class="form-text">Token bot dari @BotFather</div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="admin_ids" class="form-label">ID Admin</label>
                            <input type="text" class="form-control" id="admin_ids" name="admin_ids" 
                                   value="<?= htmlspecialchars(Config::get('TELEGRAM_ADMIN_IDS')) ?>">
                            <div class="form-text">ID Telegram admin, pisahkan dengan koma</div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="channel_id" class="form-label">ID Channel</label>
                            <input type="text" class="form-control" id="channel_id" name="channel_id" 
                                   value="<?= htmlspecialchars(Config::get('TELEGRAM_CHANNEL_ID')) ?>">
                            <div class="form-text">Username channel dengan @ atau ID numerik</div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="welcome_message" class="form-label">Pesan Selamat Datang</label>
                            <textarea class="form-control" id="welcome_message" name="welcome_message" rows="3"><?= 
                                htmlspecialchars(Config::get('BOT_WELCOME_MESSAGE')) 
                            ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label for="default_response" class="form-label">Respon Default</label>
                            <textarea class="form-control" id="default_response" name="default_response" rows="3"><?= 
                                htmlspecialchars(Config::get('BOT_DEFAULT_RESPONSE')) 
                            ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="maintenance_mode" 
                                       name="maintenance_mode" value="1" <?= 
                                       Config::get('BOT_MAINTENANCE_MODE') === 'true' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="maintenance_mode">Mode Maintenance</label>
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>