<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/../config/Database.php';
require_once __DIR__ . '/../config/TelegramBot.php';

$db = Database::getInstance()->getConnection();
$bot = new TelegramBot();

$success = '';
$error = '';

// Handle broadcast form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $message = trim($_POST['message']);
    $parseMode = $_POST['parse_mode'] ?? 'HTML';
    $target = $_POST['target'] ?? 'all';
    
    try {
        if (empty($message)) {
            throw new Exception('Pesan tidak boleh kosong');
        }
        
        if ($target === 'all') {
            $result = $bot->broadcastMessage($message, [
                'parse_mode' => $parseMode
            ]);
            
            $success = sprintf(
                "Broadcast berhasil dikirim ke %d pengguna (%d gagal).",
                $result['success'],
                $result['failures']
            );
        } elseif ($target === 'channel') {
            $channelId = Config::get('TELEGRAM_CHANNEL_ID');
            if (!$channelId) {
                throw new Exception('ID Channel belum dikonfigurasi');
            }
            
            $bot->sendToChannel($channelId, $message, 'text', [
                'parse_mode' => $parseMode
            ]);
            
            $success = "Pesan berhasil dikirim ke channel.";
        }
        
        // Log broadcast
        $db->prepare("
            INSERT INTO broadcasts 
            (admin_id, message, target, sent_at) 
            VALUES (:admin_id, :message, :target, NOW())
        ")->execute([
            ':admin_id' => $_SESSION['admin_username'],
            ':message' => $message,
            ':target' => $target
        ]);
    } catch (Exception $e) {
        $error = 'Gagal mengirim broadcast: ' . $e->getMessage();
    }
}

// Get broadcast history
$broadcastHistory = $db->query("
    SELECT * FROM broadcasts 
    ORDER BY sent_at DESC 
    LIMIT 10
")->fetchAll();

require_once __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Broadcast Pesan</h1>
            </div>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <div class="row">
                <div class="col-md-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>Kirim Pesan</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="target" class="form-label">Tujuan</label>
                                    <select class="form-select" id="target" name="target">
                                        <option value="all">Semua Pengguna</option>
                                        <option value="channel">Channel Telegram</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="parse_mode" class="form-label">Format Pesan</label>
                                    <select class="form-select" id="parse_mode" name="parse_mode">
                                        <option value="HTML">HTML</option>
                                        <option value="Markdown">Markdown</option>
                                        <option value="MarkdownV2">Markdown V2</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="message" class="form-label">Pesan</label>
                                    <textarea class="form-control" id="message" name="message" rows="6" required></textarea>
                                    <div class="form-text">
                                        Format HTML: &lt;b&gt;bold&lt;/b&gt;, &lt;i&gt;italic&lt;/i&gt;, &lt;a href="..."&gt;link&lt;/a&gt;
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Kirim Broadcast</button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h5>Riwayat Broadcast</h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($broadcastHistory)): ?>
                                <p class="text-muted">Belum ada riwayat broadcast</p>
                            <?php else: ?>
                                <div class="list-group">
                                    <?php foreach ($broadcastHistory as $broadcast): ?>
                                        <div class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between">
                                                <small class="text-muted"><?= 
                                                    htmlspecialchars($broadcast['target']) 
                                                ?></small>
                                                <small><?= 
                                                    date('d M H:i', strtotime($broadcast['sent_at'])) 
                                                ?></small>
                                            </div>
                                            <p class="mb-1"><?= 
                                                htmlspecialchars(substr($broadcast['message'], 0, 50)) . 
                                                (strlen($broadcast['message']) > 50 ? '...' : '')
                                            ?></p>
                                            <small>Oleh: <?= 
                                                htmlspecialchars($broadcast['admin_id']) 
                                            ?></small>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>