<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/../config/Database.php';
require_once __DIR__ . '/../config/TelegramBot.php';

$db = Database::getInstance()->getConnection();
$bot = new TelegramBot();

$success = '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $message = trim($_POST['message']);
    $postType = $_POST['post_type'] ?? 'text';
    $parseMode = $_POST['parse_mode'] ?? 'HTML';
    
    try {
        $channelId = Config::get('TELEGRAM_CHANNEL_ID');
        if (!$channelId) {
            throw new Exception('ID Channel belum dikonfigurasi');
        }
        
        $options = [
            'parse_mode' => $parseMode
        ];
        
        if ($postType === 'photo' && isset($_FILES['photo'])) {
            $photo = $_FILES['photo'];
            $tempPath = sys_get_temp_dir() . '/' . $photo['name'];
            move_uploaded_file($photo['tmp_name'], $tempPath);
            
            $result = $bot->sendPhoto($channelId, $tempPath, $message, $options);
            unlink($tempPath);
        } elseif ($postType === 'document' && isset($_FILES['document'])) {
            $document = $_FILES['document'];
            $tempPath = sys_get_temp_dir() . '/' . $document['name'];
            move_uploaded_file($document['tmp_name'], $tempPath);
            
            $result = $bot->sendDocument($channelId, $tempPath, $message, $options);
            unlink($tempPath);
        } else {
            $result = $bot->sendToChannel($channelId, $message, 'text', $options);
        }
        
        // Log the post
        $db->prepare("
            INSERT INTO channel_posts 
            (admin_id, message, post_type, posted_at) 
            VALUES (:admin_id, :message, :post_type, NOW())
        ")->execute([
            ':admin_id' => $_SESSION['admin_username'],
            ':message' => $message,
            ':post_type' => $postType
        ]);
        
        $success = 'Posting berhasil dikirim ke channel!';
    } catch (Exception $e) {
        $error = 'Gagal memposting ke channel: ' . $e->getMessage();
    }
}

// Get post history
$postHistory = $db->query("
    SELECT * FROM channel_posts 
    ORDER BY posted_at DESC 
    LIMIT 10
")->fetchAll();

require_once __DIR__ . '/includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Posting ke Channel</h1>
            </div>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <div class="row">
                <div class="col-md-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>Buat Posting Baru</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label for="post_type" class="form-label">Jenis Posting</label>
                                    <select class="form-select" id="post_type" name="post_type">
                                        <option value="text">Teks</option>
                                        <option value="photo">Foto</option>
                                        <option value="document">Dokumen</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3" id="photo-upload" style="display: none;">
                                    <label for="photo" class="form-label">Foto</label>
                                    <input type="file" class="form-control" id="photo" name="photo" accept="image/*">
                                </div>
                                
                                <div class="mb-3" id="document-upload" style="display: none;">
                                    <label for="document" class="form-label">Dokumen</label>
                                    <input type="file" class="form-control" id="document" name="document">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="parse_mode" class="form-label">Format Pesan</label>
                                    <select class="form-select" id="parse_mode" name="parse_mode">
                                        <option value="HTML">HTML</option>
                                        <option value="Markdown">Markdown</option>
                                        <option value="MarkdownV2">Markdown V2</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="message" class="form-label">Pesan / Caption</label>
                                    <textarea class="form-control" id="message" name="message" rows="6" required></textarea>
                                    <div class="form-text">
                                        Format HTML: &lt;b&gt;bold&lt;/b&gt;, &lt;i&gt;italic&lt;/i&gt;, &lt;a href="..."&gt;link&lt;/a&gt;
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Posting ke Channel</button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h5>Riwayat Posting</h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($postHistory)): ?>
                                <p class="text-muted">Belum ada riwayat posting</p>
                            <?php else: ?>
                                <div class="list-group">
                                    <?php foreach ($postHistory as $post): ?>
                                        <div class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between">
                                                <small class="text-muted"><?= 
                                                    htmlspecialchars($post['post_type']) 
                                                ?></small>
                                                <small><?= 
                                                    date('d M H:i', strtotime($post['posted_at'])) 
                                                ?></small>
                                            </div>
                                            <p class="mb-1"><?= 
                                                htmlspecialchars(substr($post['message'], 0, 50)) . 
                                                (strlen($post['message']) > 50 ? '...' : '')
                                            ?></p>
                                            <small>Oleh: <?= 
                                                htmlspecialchars($post['admin_id']) 
                                            ?></small>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
    // Show/hide file upload based on post type
    document.getElementById('post_type').addEventListener('change', function() {
        const postType = this.value;
        document.getElementById('photo-upload').style.display = postType === 'photo' ? 'block' : 'none';
        document.getElementById('document-upload').style.display = postType === 'document' ? 'block' : 'none';
    });
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>