<?php
class InlineKeyboard {
    public static function createMainMenu() {
        return [
            'inline_keyboard' => [
                [
                    ['text' => '📋 Informasi Produk', 'callback_data' => 'menu:products'],
                    ['text' => '🛒 Belanja', 'callback_data' => 'menu:shop']
                ],
                [
                    ['text' => '📞 Hubungi Kami', 'callback_data' => 'menu:contact'],
                    ['text' => '⚙️ Pengaturan', 'callback_data' => 'menu:settings']
                ],
                [
                    ['text' => '🌟 Beri Rating', 'url' => 'https://t.me/store/rating']
                ]
            ]
        ];
    }
    
    public static function createProductList($products, $page = 1, $perPage = 5) {
        $keyboard = [];
        $totalPages = ceil(count($products) / $perPage);
        $offset = ($page - 1) * $perPage;
        $paginatedProducts = array_slice($products, $offset, $perPage);
        
        foreach ($paginatedProducts as $product) {
            $keyboard[] = [
                [
                    'text' => $product['name'],
                    'callback_data' => 'product:' . $product['id']
                ]
            ];
        }
        
        // Add pagination buttons
        $paginationRow = [];
        if ($page > 1) {
            $paginationRow[] = ['text' => '⬅️ Sebelumnya', 'callback_data' => 'products:' . ($page - 1)];
        }
        if ($page < $totalPages) {
            $paginationRow[] = ['text' => 'Selanjutnya ➡️', 'callback_data' => 'products:' . ($page + 1)];
        }
        
        if (!empty($paginationRow)) {
            $keyboard[] = $paginationRow;
        }
        
        // Add back button
        $keyboard[] = [
            ['text' => '🔙 Kembali ke Menu', 'callback_data' => 'menu:main']
        ];
        
        return ['inline_keyboard' => $keyboard];
    }
    
    public static function createProductDetail($productId, $inCart = false) {
        $keyboard = [
            [
                ['text' => '🛒 Tambah ke Keranjang', 'callback_data' => 'add_to_cart:' . $productId]
            ],
            [
                ['text' => '📋 Deskripsi Lengkap', 'url' => 'https://example.com/products/' . $productId]
            ],
            [
                ['text' => '🔙 Kembali ke Produk', 'callback_data' => 'menu:products:1']
            ]
        ];
        
        if ($inCart) {
            $keyboard[0][0]['text'] = '✅ Sudah di Keranjang';
            $keyboard[0][0]['callback_data'] = 'already_in_cart';
        }
        
        return ['inline_keyboard' => $keyboard];
    }
    
    public static function createConfirmation($action, $id) {
        return [
            'inline_keyboard' => [
                [
                    ['text' => '✅ Ya', 'callback_data' => $action . '_confirm:' . $id],
                    ['text' => '❌ Tidak', 'callback_data' => $action . '_cancel:' . $id]
                ]
            ]
        ];
    }
    
    public static function createContactOptions() {
        return [
            'inline_keyboard' => [
                [
                    ['text' => '📞 Telepon', 'callback_data' => 'contact:phone'],
                    ['text' => '📧 Email', 'callback_data' => 'contact:email']
                ],
                [
                    ['text' => '🗺️ Lokasi', 'callback_data' => 'contact:location'],
                    ['text' => '🌐 Website', 'url' => 'https://example.com']
                ],
                [
                    ['text' => '🔙 Kembali ke Menu', 'callback_data' => 'menu:main']
                ]
            ]
        ];
    }
}